/*****************************************************************************
* SPSSload_NIS_2007_Core.SPS
* This program will load the 2007 NIS ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2007_Core.ASC' FIXED / 
    AGE                        1-  3
    AGEDAY                     4-  6
    AMONTH                     7-  8
    ASOURCE                    9- 10
    ASOURCEU                  11     (A)
    ASOURCE_                  12- 19 (A)
    ATYPE                     20- 21
    AWEEKEND                  22- 23
    DIED                      24- 25
    DISCWT                    26- 36
    DISPUB04                  37- 38
    DISPUNIF                  39- 40
    DQTR                      41- 42
    DQTR_X                    43- 44
    DRG                       45- 47
    DRG24                     48- 50
    DRGVER                    51- 52
    DSHOSPID                  53- 65 (A)
    DX1                       66- 70 (A)
    DX2                       71- 75 (A)
    DX3                       76- 80 (A)
    DX4                       81- 85 (A)
    DX5                       86- 90 (A)
    DX6                       91- 95 (A)
    DX7                       96-100 (A)
    DX8                      101-105 (A)
    DX9                      106-110 (A)
    DX10                     111-115 (A)
    DX11                     116-120 (A)
    DX12                     121-125 (A)
    DX13                     126-130 (A)
    DX14                     131-135 (A)
    DX15                     136-140 (A)
    DXCCS1                   141-143
    DXCCS2                   144-146
    DXCCS3                   147-149
    DXCCS4                   150-152
    DXCCS5                   153-155
    DXCCS6                   156-158
    DXCCS7                   159-161
    DXCCS8                   162-164
    DXCCS9                   165-167
    DXCCS10                  168-170
    DXCCS11                  171-173
    DXCCS12                  174-176
    DXCCS13                  177-179
    DXCCS14                  180-182
    DXCCS15                  183-185
    ECODE1                   186-190 (A)
    ECODE2                   191-195 (A)
    ECODE3                   196-200 (A)
    ECODE4                   201-205 (A)
    ELECTIVE                 206-207
    E_CCS1                   208-211
    E_CCS2                   212-215
    E_CCS3                   216-219
    E_CCS4                   220-223
    FEMALE                   224-225
    HCUP_ED                  226-228
    HOSPBRTH                 229-230
    HOSPID                   231-235
    HOSPST                   236-237 (A)
    KEY                      238-251
    LOS                      252-256
    LOS_X                    257-262
    MDC                      263-264
    MDC24                    265-266
    MDNUM1_R                 267-271
    MDNUM2_R                 272-276
    NDX                      277-278
    NECODE                   279-281
    NEOMAT                   282-283
    NIS_STRA                 284-287
    NPR                      288-289
    PAY1                     290-291
    PAY1_X                   292-301 (A)
    PAY2                     302-303
    PAY2_X                   304-313 (A)
    PL_NCHS2                 314-316
    PR1                      317-320 (A)
    PR2                      321-324 (A)
    PR3                      325-328 (A)
    PR4                      329-332 (A)
    PR5                      333-336 (A)
    PR6                      337-340 (A)
    PR7                      341-344 (A)
    PR8                      345-348 (A)
    PR9                      349-352 (A)
    PR10                     353-356 (A)
    PR11                     357-360 (A)
    PR12                     361-364 (A)
    PR13                     365-368 (A)
    PR14                     369-372 (A)
    PR15                     373-376 (A)
    PRCCS1                   377-379
    PRCCS2                   380-382
    PRCCS3                   383-385
    PRCCS4                   386-388
    PRCCS5                   389-391
    PRCCS6                   392-394
    PRCCS7                   395-397
    PRCCS8                   398-400
    PRCCS9                   401-403
    PRCCS10                  404-406
    PRCCS11                  407-409
    PRCCS12                  410-412
    PRCCS13                  413-415
    PRCCS14                  416-418
    PRCCS15                  419-421
    PRDAY1                   422-424
    PRDAY2                   425-427
    PRDAY3                   428-430
    PRDAY4                   431-433
    PRDAY5                   434-436
    PRDAY6                   437-439
    PRDAY7                   440-442
    PRDAY8                   443-445
    PRDAY9                   446-448
    PRDAY10                  449-451
    PRDAY11                  452-454
    PRDAY12                  455-457
    PRDAY13                  458-460
    PRDAY14                  461-463
    PRDAY15                  464-466
    POO_UB04                 467     (A)
    POO_X                    468-475 (A)
    RACE                     476-477
    TOTCHG                   478-487
    TOTCHG_X                 488-502
    YEAR                     503-506
    ZIPINC_Q                 507-508.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB04                 (F2.0) /
    DISPUNIF                 (F2.0) /
    DQTR                     (F2.0) /
    DQTR_X                   (F2.0) /
    DRG                      (F3.0) /
    DRG24                    (F3.0) /
    DRGVER                   (F2.0) /
    DXCCS1                   (F3.0) /
    DXCCS2                   (F3.0) /
    DXCCS3                   (F3.0) /
    DXCCS4                   (F3.0) /
    DXCCS5                   (F3.0) /
    DXCCS6                   (F3.0) /
    DXCCS7                   (F3.0) /
    DXCCS8                   (F3.0) /
    DXCCS9                   (F3.0) /
    DXCCS10                  (F3.0) /
    DXCCS11                  (F3.0) /
    DXCCS12                  (F3.0) /
    DXCCS13                  (F3.0) /
    DXCCS14                  (F3.0) /
    DXCCS15                  (F3.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSPBRTH                 (F2.0) /
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC24                    (F2.0) /
    MDNUM1_R                 (F5.0) /
    MDNUM2_R                 (F5.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NIS_STRA                 (F4.0) /
    NPR                      (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_NCHS2                 (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    YEAR                     (F4.0) /
    ZIPINC_Q                 (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEU                 "Admission source (UB-92 standard coding)"
    ASOURCE_                 "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB04                 "Disposition of patient (UB-04 standard coding)"
    DISPUNIF                 "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DQTR_X                   "Discharge quarter (as received from source)"
    DRG                      "DRG in effect on discharge date"
    DRG24                    "DRG, version 24"
    DRGVER                   "DRG grouper version used on discharge date"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSPBRTH                 "Indicator of birth in this hospital"
    HOSPID                   "HCUP hospital identification number"
    HOSPST                   "Hospital state postal code"
    KEY                      "HCUP record identifier"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC24                    "MDC, version 24"
    MDNUM1_R                 "Physician 1 number (re-identified)"
    MDNUM2_R                 "Physician 2 number (re-identified)"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NIS_STRA                 "Stratum used to sample hospital"
    NPR                      "Number of procedures on this record"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_NCHS2                 "Patient Location: NCHS Urban-Rural Code (V2006)"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    POO_UB04                 "Point of origin for admission or visit, UB-04 standard coding"
    POO_X                    "Point of origin for admission or visit, as received from source"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    YEAR                     "Calendar year"
    ZIPINC_Q                 "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB04                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIF                 (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DQTR_X                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG24                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-99 -88 -66=SYSMIS).
RECODE DXCCS2                   (-99 -88 -66=SYSMIS).
RECODE DXCCS3                   (-99 -88 -66=SYSMIS).
RECODE DXCCS4                   (-99 -88 -66=SYSMIS).
RECODE DXCCS5                   (-99 -88 -66=SYSMIS).
RECODE DXCCS6                   (-99 -88 -66=SYSMIS).
RECODE DXCCS7                   (-99 -88 -66=SYSMIS).
RECODE DXCCS8                   (-99 -88 -66=SYSMIS).
RECODE DXCCS9                   (-99 -88 -66=SYSMIS).
RECODE DXCCS10                  (-99 -88 -66=SYSMIS).
RECODE DXCCS11                  (-99 -88 -66=SYSMIS).
RECODE DXCCS12                  (-99 -88 -66=SYSMIS).
RECODE DXCCS13                  (-99 -88 -66=SYSMIS).
RECODE DXCCS14                  (-99 -88 -66=SYSMIS).
RECODE DXCCS15                  (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC24                    (-9 -8 -6 -5=SYSMIS).
RECODE MDNUM1_R                 (-9999 -8888 -6666=SYSMIS).
RECODE MDNUM2_R                 (-9999 -8888 -6666=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRA                 (-999 -888 -666=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2                 (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_Q                 (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2007_Core.SAV' / COMPRESSED.
