/*****************************************************************************
* SPSSload_NIS_2005_Hospital.SPS
* This program will load the 2005 NIS ASCII Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2005_Hospital.ASC' FIXED / 
    AHAID                      1-  7 (A)
    DISCWT                     8- 18
    HFIPSSTC                  19- 23
    HOSPADDR                  24- 53 (A)
    HOSPCITY                  54- 73 (A)
    HOSPID                    74- 78
    HOSPNAME                  79-108 (A)
    HOSPST                   109-110 (A)
    HOSPSTCO                 111-115
    HOSPWT                   116-126
    HOSPZIP                  127-131 (A)
    HOSP_BED                 132-133
    HOSP_CON                 134-135
    HOSP_LOC                 136-137
    HOSP_LT                  138-139
    HOSP_REG                 140-141
    HOSP_TEA                 142-143
    IDNUMBER                 144-149 (A)
    NIS_STRA                 150-153
    N_DISC_U                 154-161
    N_HOSP_U                 162-165
    S_DISC_U                 166-171
    S_HOSP_U                 172-175
    TOTAL_DI                 176-181
    YEAR                     182-185.

***  Specify write formats  ***.
FORMATS
    DISCWT                   (F11.7) /
    HFIPSSTC                 (F5.0) /
    HOSPID                   (F5.0) /
    HOSPSTCO                 (F5.0) /
    HOSPWT                   (F11.7) /
    HOSP_BED                 (F2.0) /
    HOSP_CON                 (F2.0) /
    HOSP_LOC                 (F2.0) /
    HOSP_LT                  (F2.0) /
    HOSP_REG                 (F2.0) /
    HOSP_TEA                 (F2.0) /
    NIS_STRA                 (F4.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_DISC_U                 (F6.0) /
    S_HOSP_U                 (F4.0) /
    TOTAL_DI                 (F6.0) /
    YEAR                     (F4.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AHAID                    "AHA hospital identifier with the leading 6"
    DISCWT                   "Weight to discharges in AHA universe"
    HFIPSSTC                 "Hospital FIPS state/county code"
    HOSPADDR                 "Hospital address from AHA Survey (Z011)"
    HOSPCITY                 "Hospital city from AHA Survey (Z012)"
    HOSPID                   "HCUP hospital identification number"
    HOSPNAME                 "Hospital name from AHA Survey (Z000)"
    HOSPST                   "Hospital state postal code"
    HOSPSTCO                 "Hospital modified FIPS state/county code"
    HOSPWT                   "Weight to hospitals in AHA universe"
    HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
    HOSP_BED                 "Bed size of hospital"
    HOSP_CON                 "Control/ownership of hospital"
    HOSP_LOC                 "Location (urban/rural) of hospital"
    HOSP_LT                  "Location/teaching status of hospital"
    HOSP_REG                 "Region of hospital"
    HOSP_TEA                 "Teaching status of hospital"
    IDNUMBER                 "AHA hospital identifier without the leading 6"
    NIS_STRA                 "Stratum used to sample hospital"
    N_DISC_U                 "Number of AHA universe discharges in NIS_STRATUM"
    N_HOSP_U                 "Number of AHA universe hospitals in NIS_STRATUM"
    S_DISC_U                 "Number of sample discharges in NIS_STRATUM"
    S_HOSP_U                 "Number of sample hospitals in NIS_STRATUM"
    TOTAL_DI                 "Total number of discharges from this hospital in the NIS"
    YEAR                     "Calendar Year" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HFIPSSTC                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSPSTCO                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSPWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_BED                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_CON                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOC                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LT                  (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REG                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_TEA                 (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRA                 (-999 -888 -666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_DISC_U                 (-99999 -88888 -66666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE TOTAL_DI                 (-99999 -88888 -66666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NIS_2005_Hospital.SAV' / COMPRESSED.
