/*****************************************************************************
* SPSSload_NIS_2005_Core.SPS
* This program will load the 2005 NIS ASCII Core File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2005_Core.ASC' FIXED / 
    AGE                        1-  3
    AGEDAY                     4-  6
    AMONTH                     7-  8
    ASOURCE                    9- 10
    ASOURCEU                  11     (A)
    ASOURCE_                  12- 19 (A)
    ATYPE                     20- 21
    AWEEKEND                  22- 23
    DIED                      24- 25
    DISCWT                    26- 36
    DISPUB92                  37- 38
    DISPUNIF                  39- 40
    DQTR                      41- 42
    DRG                       43- 45
    DRG18                     46- 48
    DRGVER                    49- 50
    DSHOSPID                  51- 63 (A)
    DX1                       64- 68 (A)
    DX2                       69- 73 (A)
    DX3                       74- 78 (A)
    DX4                       79- 83 (A)
    DX5                       84- 88 (A)
    DX6                       89- 93 (A)
    DX7                       94- 98 (A)
    DX8                       99-103 (A)
    DX9                      104-108 (A)
    DX10                     109-113 (A)
    DX11                     114-118 (A)
    DX12                     119-123 (A)
    DX13                     124-128 (A)
    DX14                     129-133 (A)
    DX15                     134-138 (A)
    DXCCS1                   139-142
    DXCCS2                   143-146
    DXCCS3                   147-150
    DXCCS4                   151-154
    DXCCS5                   155-158
    DXCCS6                   159-162
    DXCCS7                   163-166
    DXCCS8                   167-170
    DXCCS9                   171-174
    DXCCS10                  175-178
    DXCCS11                  179-182
    DXCCS12                  183-186
    DXCCS13                  187-190
    DXCCS14                  191-194
    DXCCS15                  195-198
    ECODE1                   199-203 (A)
    ECODE2                   204-208 (A)
    ECODE3                   209-213 (A)
    ECODE4                   214-218 (A)
    ELECTIVE                 219-220
    E_CCS1                   221-224
    E_CCS2                   225-228
    E_CCS3                   229-232
    E_CCS4                   233-236
    FEMALE                   237-238
    HOSPID                   239-243
    HOSPST                   244-245 (A)
    KEY                      246-259
    LOS                      260-264
    LOS_X                    265-270
    MDC                      271-272
    MDC18                    273-274
    MDNUM1_R                 275-279
    MDNUM2_R                 280-284
    NDX                      285-286
    NECODE                   287-289
    NEOMAT                   290-291
    NIS_STRA                 292-295
    NPR                      296-297
    PAY1                     298-299
    PAY1_X                   300-309 (A)
    PAY2                     310-311
    PAY2_X                   312-321 (A)
    PL_UR_CA                 322-323
    PR1                      324-327 (A)
    PR2                      328-331 (A)
    PR3                      332-335 (A)
    PR4                      336-339 (A)
    PR5                      340-343 (A)
    PR6                      344-347 (A)
    PR7                      348-351 (A)
    PR8                      352-355 (A)
    PR9                      356-359 (A)
    PR10                     360-363 (A)
    PR11                     364-367 (A)
    PR12                     368-371 (A)
    PR13                     372-375 (A)
    PR14                     376-379 (A)
    PR15                     380-383 (A)
    PRCCS1                   384-386
    PRCCS2                   387-389
    PRCCS3                   390-392
    PRCCS4                   393-395
    PRCCS5                   396-398
    PRCCS6                   399-401
    PRCCS7                   402-404
    PRCCS8                   405-407
    PRCCS9                   408-410
    PRCCS10                  411-413
    PRCCS11                  414-416
    PRCCS12                  417-419
    PRCCS13                  420-422
    PRCCS14                  423-425
    PRCCS15                  426-428
    PRDAY1                   429-431
    PRDAY2                   432-434
    PRDAY3                   435-437
    PRDAY4                   438-440
    PRDAY5                   441-443
    PRDAY6                   444-446
    PRDAY7                   447-449
    PRDAY8                   450-452
    PRDAY9                   453-455
    PRDAY10                  456-458
    PRDAY11                  459-461
    PRDAY12                  462-464
    PRDAY13                  465-467
    PRDAY14                  468-470
    PRDAY15                  471-473
    RACE                     474-475
    TOTCHG                   476-485
    TOTCHG_X                 486-500
    YEAR                     501-504
    ZIPInc_Q                 505-506.

***  Specify write formats  ***.
FORMATS
    AGE                      (F3.0) /
    AGEDAY                   (F3.0) /
    AMONTH                   (F2.0) /
    ASOURCE                  (F2.0) /
    ATYPE                    (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUB92                 (F2.0) /
    DISPUNIF                 (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRG18                    (F3.0) /
    DRGVER                   (F2.0) /
    DXCCS1                   (F4.0) /
    DXCCS2                   (F4.0) /
    DXCCS3                   (F4.0) /
    DXCCS4                   (F4.0) /
    DXCCS5                   (F4.0) /
    DXCCS6                   (F4.0) /
    DXCCS7                   (F4.0) /
    DXCCS8                   (F4.0) /
    DXCCS9                   (F4.0) /
    DXCCS10                  (F4.0) /
    DXCCS11                  (F4.0) /
    DXCCS12                  (F4.0) /
    DXCCS13                  (F4.0) /
    DXCCS14                  (F4.0) /
    DXCCS15                  (F4.0) /
    ELECTIVE                 (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    FEMALE                   (F2.0) /
    HOSPID                   (F5.0) /
    KEY                      (F14.0) /
    LOS                      (F5.0) /
    LOS_X                    (F6.0) /
    MDC                      (F2.0) /
    MDC18                    (F2.0) /
    MDNUM1_R                 (F5.0) /
    MDNUM2_R                 (F5.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NIS_STRA                 (F4.0) /
    NPR                      (F2.0) /
    PAY1                     (F2.0) /
    PAY2                     (F2.0) /
    PL_UR_CA                 (F2.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TOTCHG_X                 (F15.2) /
    YEAR                     (F4.0) /
    ZIPInc_Q                 (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AGEDAY                   "Age in days (when age < 1 year)"
    AMONTH                   "Admission month"
    ASOURCE                  "Admission source (uniform)"
    ASOURCEU                 "Admission source (UB-92 standard coding)"
    ASOURCE_                 "Admission source (as received from source)"
    ATYPE                    "Admission type"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "Weight to discharges in AHA universe"
    DISPUB92                 "Disposition of patient (UB-92 standard coding)"
    DISPUNIF                 "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRG18                    "DRG, version 18"
    DRGVER                   "DRG grouper version used on discharge date"
    DSHOSPID                 "Data source hospital identifier"
    DX1                      "Principal diagnosis"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DXCCS1                   "CCS: principal diagnosis"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    ELECTIVE                 "Elective versus non-elective admission"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HOSPID                   "HCUP hospital identification number"
    HOSPST                   "Hospital state postal code"
    KEY                      "HCUP record identifier"
    LOS                      "Length of stay (cleaned)"
    LOS_X                    "Length of stay (as received from source)"
    MDC                      "MDC in effect on discharge date"
    MDC18                    "MDC, version 18"
    MDNUM1_R                 "Physician 1 number (re-identified)"
    MDNUM2_R                 "Physician 2 number (re-identified)"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NIS_STRA                 "Stratum used to sample hospital"
    NPR                      "Number of procedures on this record"
    PAY1                     "Primary expected payer (uniform)"
    PAY1_X                   "Primary expected payer (as received from source)"
    PAY2                     "Secondary expected payer (uniform)"
    PAY2_X                   "Secondary expected payer (as received from source)"
    PL_UR_CA                 "Patient Location: Urban-Rural 4 Categories"
    PR1                      "Principal procedure"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: principal procedure"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TOTCHG_X                 "Total charges (as received from source)"
    YEAR                     "Calendar year"
    ZIPInc_Q                 "Median household income quartile for patient's ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGEDAY                   (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE ASOURCE                  (-9 -8 -6 -5=SYSMIS).
RECODE ATYPE                    (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUB92                 (-9 -8 -6 -5=SYSMIS).
RECODE DISPUNIF                 (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG18                    (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-999 -888 -666=SYSMIS).
RECODE DXCCS2                   (-999 -888 -666=SYSMIS).
RECODE DXCCS3                   (-999 -888 -666=SYSMIS).
RECODE DXCCS4                   (-999 -888 -666=SYSMIS).
RECODE DXCCS5                   (-999 -888 -666=SYSMIS).
RECODE DXCCS6                   (-999 -888 -666=SYSMIS).
RECODE DXCCS7                   (-999 -888 -666=SYSMIS).
RECODE DXCCS8                   (-999 -888 -666=SYSMIS).
RECODE DXCCS9                   (-999 -888 -666=SYSMIS).
RECODE DXCCS10                  (-999 -888 -666=SYSMIS).
RECODE DXCCS11                  (-999 -888 -666=SYSMIS).
RECODE DXCCS12                  (-999 -888 -666=SYSMIS).
RECODE DXCCS13                  (-999 -888 -666=SYSMIS).
RECODE DXCCS14                  (-999 -888 -666=SYSMIS).
RECODE DXCCS15                  (-999 -888 -666=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE LOS_X                    (-99999 -88888 -66666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC18                    (-9 -8 -6 -5=SYSMIS).
RECODE MDNUM1_R                 (-9999 -8888 -6666=SYSMIS).
RECODE MDNUM2_R                 (-9999 -8888 -6666=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NIS_STRA                 (-999 -888 -666=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_UR_CA                 (-9 -8 -6 -5=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TOTCHG_X                 (-99999999999.99 -88888888888.88 -66666666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPInc_Q                 (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NIS_2005_Core.SAV' / COMPRESSED.
